//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Net;
using System.Net.Sockets;

namespace Bench
{
	/// <summary>
	/// Podsumowanie dla UdpClientTest.
	/// </summary>
	public class UdpClientTest : NetworkTest
	{
		public UdpClientTest(string server, int port, int numberOfPackets, int packetSize) :
			base(server, port, numberOfPackets, packetSize)
		{
		}
		public override void Start()
		{
			UdpClient client = new UdpClient();
 
			IPAddress address = Dns.Resolve(Server).AddressList[0];
			IPEndPoint remoteEp = new IPEndPoint(address, Port);

			byte[] writeBuffer = new byte[PacketSize];
			int nTransmitted;
			int nTotalReceived;

			TransmitByteCount = 0;
			ReceivedByteCount = 0;

			// Wysanie losowych bajtw
			{
				client.Send(writeBuffer, 100, Server, Port);
				byte [] readBuffer = client.Receive(ref remoteEp);
			}

			// Wykonanie testu
			StartCounters();
			int startTime = Environment.TickCount;
			for(int i = 0; i < NumberOfPackets; i++)
			{
				nTransmitted = client.Send(writeBuffer, writeBuffer.Length, Server, Port);
				TransmitByteCount += nTransmitted;
				for(nTotalReceived = 0; nTotalReceived < nTransmitted;)
				{
					byte [] readBuffer = client.Receive(ref remoteEp);
					ReceivedByteCount += readBuffer.Length;
					nTotalReceived += readBuffer.Length;
				}
			}
			int endTime = Environment.TickCount;
			StopCounters();

			Elapsed = endTime - startTime;

			client.Close();
		}
	}
}
